package gov.va.genisis2.util.rest.helper;

import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.AbstractMockMvcTests;

/**
 * 
 * @author1 Janet Lopez
 * 
 * The Class ResponseWrapperTest.
 * 
 * Description: In this ResponseWrapperTest Class which extends the abstract
 * class, AbstractMockMvcTests, junit tests are defined.
 * 
 */
public class ResponseWrapperTest extends AbstractMockMvcTests {
	
	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(ResponseWrapperTest.class);

	/**
	 * Test response wrapper.
	 */
	@Test
	public void TestResponseWrapper() {

		LOGGER.info("**********Junit Test Response Wrapper**********");

		ResponseWrapper wrapper = new ResponseWrapper();
		String message = StringUtils.EMPTY;
		Assert.assertNull(wrapper.getResponse());
		Assert.assertEquals(message, wrapper.getMessage());
		Assert.assertFalse(wrapper.getSuccess());

		wrapper.setSuccess(true);
		wrapper.setMessage("messageTestOne");
		wrapper.setResponse("responseTestOne");

		Assert.assertTrue(wrapper.getSuccess());
		Assert.assertEquals("messageTestOne", wrapper.getMessage());
		Assert.assertEquals("responseTestOne", wrapper.getResponse());

		LOGGER.info("**********End of Junit Test Response Wrapper**********");

	}

}
